

# Generalizable Deep RL-Based TSP Solver via Approximate Invariance (Pre-released Code)

This is a pre-released version, and should be appended in supplementary materials.

We include codes for experiments related to our method presented in the article. Due to size limitations, we do not include our trained model and generated dataset. (The reviewer can still reproduce them using the provided code easily.) The link to Github is hidden now in order not to leak authors’ information.

[TOC]



## Installation

You are recommended to follow the following installation instructions and use the same version of python modules.

We use anaconda to manage python modules. See [Anaconda 3 official website](https://www.anaconda.com/download/).

**Step 1 — create your own environment**

```
conda create -n [ENV_NAME] python==3.9
conda activate [ENV_NAME]
```

**Step 2 — install pytorch and related modules**

Follow the [Pytorch official webste](https://pytorch.org/get-started/previous-versions/) to install `pytorch==1.12.1`, accompanied with `torchvision==0.13.1` and `torchaudio==0.12.1`

Then install `torch_cluster` with corresponding pytorch version and cuda version

```bash
conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 cudatoolkit=11.3 -c pytorch
conda install pytorch-cluster -c pyg
```

**Step 3 — install other modules**

```bash
pip install elkai==2.0.1
pip install rich_argparse_plus==0.3.1.4
pip install tqdm==4.66.1
```



## Guidance

- All commands listed in the file should be executed in the root directory, the project directory
- You should follow the pipeline `installation` $\to$ `generate instances` $\to$ `model phase inference` $\to$ `MCTS`
- Try to use the same version of Python packages, or there may be unexpected errors
- Executable programs have `-h | --help` option to generate arguments description
- All arguments have default values, the same as mentioned in the article.
- Make sure to have a GPU warmup if you want an accurate measurement of inference time.



## TSP Instances

### Random TSP Instance

Random TSP instance with size $n$ contains $n$ points on a unit square, and each node is independently, uniformly distributed.

Run the following command to generate random TSP instances

```bash
python ./generator/generate_random_tsp.py --size={SIZE} --num={NUM}
```

- size — size of TSP instances
- num — number of generated instances

With default arguments, all the data will be saved in `./data/tspfarm/`, with filename `TSP{SIZE}.txt`

A default data pack already contains 1000 instances for TSP20, 50, 100, 200, 500, 1000. It is also used for the evaluation of the article. (hidden now due to size limitations)

:warning: By default, the program will overwrite the file.

### KNN Stats for Random TSP Instances

Run the following command to generate K-nearest node statistics for optimal tours

```bash
python ./generator/knn_stats.py --path={FILE PATH}
```

### Noisy Perturbation Stats for Random TSP Instances

Run the following command to generate the solution gap statistics induced by noisy perturbation

```bash
python ./generator/aug_stats.py --path={FILE PATH} --noise={NOISE}
```

### TSPLIB

TSPLIB instance is directly downloaded from http://comopt.ifi.uni-heidelberg.de/software/TSPLIB95/tsp/.

All the data should be saved in `./data/tsplib/`



## Model Training

As an RL algorithm, our model training does not rely on pre-determined instances.

Run the following command to train a model

```bash
python ./scripts/train.py --{OPTIONS}={VALUE}...
```

It is best to run `-h | --help` first to see all the available arguments. Here are some important parameters for tuning.

- `--nb-layers-global-encoder` — number of layers for the *global encoder*
- `--nb-layers-local-encoder` — number of layers for the *local encoder*
- `--nb-layers-decoder` — number of layers for the *decoder*
- `--local-k` — the range of local $k$-NN graph
- `--size` — the generated TSP size during training

For more details, see the source code and our article.



## Evaluation of Random TSP

### Model Phase

There is a sample model provided at `./models/checkpoint_23-08-17--04-49-43-n50-gpu0.pkl` (hidden now due to size limitations)

You need to first prepare the data set (created by [TSP Instances](#TSP Instances)) at `./data/tspfarm/tsp{size}.txt` and a model (trained by [Model Training](#Model Training))

Then the following command is used to evaluate

```bash
python ./evaluation/eval.py --model-path={MODEL PATH} --size={SIZE} --aug-size={AUG SIZE}
```

If you train your own model, make sure that hyperparameters are set to the same.

This program reads `./data/tspfarm/tsp{size}.txt` and produces three outputs:

- Provide the results and statistics for pure model inference. Solutions in `./MCTS/data/tsp{size}/init_sol/`
- Transform tspfarm instances into the format for MCTS, saved in `./MCTS/data/tsp{size}/instances/`
- Provide heatmap in `./MCTS/data/tsp{size}/heatmap/` and initial solutions for the search phase

:warning: By default, the program refresh all materials in `./MCTS/data/tsp{size}/`

### Search Phase

The code is **modified** from [Generalize a Small Pre-trained Model to Arbitrarily Large TSP Instances](https://doi.org/10.1609/aaai.v35i8.16916).

**Step 0 — Following the above sections to generate the necessary data for MCTS**

- tsp instances
- initial solutions
- heatmaps

**Step 1 — compile the C++ code (needed at the first time and after the code is changed)**

```bash
cd ./MCTS/
rm ./code/TSP.o # if needed
rm ./test # if needed
make
cd ../
```

**Step 2 — run the program for random TSP instances**

```bash
./MCTS/test {OUTPUT FILE} {DATA ROOT} {SIZE} {NUM} tsp_random ""
# here is an example
mkdir ./MCTS/results/ # make sure that all directories exist
./MCTS/test ./MCTS/results/tsp20_results.txt ./MCTS/data/tsp20/ 20 1000 tsp_random ""
```

This program reads all related data and produces the outputs:

- The final solutions and the statistics. Results in `./MCTS/results/`



## Evaluation of TSPLIB

### Model Phase

evaluation includes instances listed in `utils.tsplib_collections`

There is a sample model provided at `./models/checkpoint_23-08-17--04-49-43-n50-gpu0.pkl` (hidden now due to size limitations)

You need to first prepare the data set (downloaded followed by [TSP Instances](#TSP Instances)) at `./data/tsplib/` and a model (trained by [Model Training](#Model Training))

Then the following command is used to evaluate

```bash
python ./evaluation/eval_tsplib.py
```

If you train your own model, make sure that hyperparameters are set to the same.

This program reads `./data/tsplib/` and produces three outputs

- Provide the results and statistics for pure model inference. Solutions in `./MCTS/data/tsplib/init_sol/`
- Transform tsplib instances into the format for MCTS, saved in `./MCTS/data/tsplib/instances/`
- Provide heatmap in `./MCTS/data/tsplib/heatmap/` and initial solutions for the search phase

:warning: By default, the program refresh all materials in `./MCTS/data/tsplib/`

### Search Phase

The code is **modified** from [Generalize a Small Pre-trained Model to Arbitrarily Large TSP Instances](https://doi.org/10.1609/aaai.v35i8.16916).

**Step 0 — Following the above sections to generate the necessary data for MCTS**

- tsp instances
- initial solutions
- heatmaps

**Step 1 — compile the C++ code (needed at the first time and after the code is changed)**

```bash
cd ./MCTS/
rm ./code/TSP.o # if needed
rm ./test # if needed
make
cd ../
```

**Step 2 — run the program for TSPLIB instances**

```bash
./MCTS/test {OUTPUT FILE} {DATA ROOT} {SIZE} 1 tsplib {NAME}
# here is an example
mkdir ./MCTS/results/ # make sure that all directories exist
./MCTS/test ./MCTS/results/tsplib_att48.txt ./MCTS/data/tsplib/ 48 1 tsplib att48
```

This program reads all related data and produces the outputs:

- The final solution and the statistics. Results in `./MCTS/results/`

