### Use this script to run the agentify_script.py script in docker container

### The binding volume should be the path to the directory containing the agentify_script.py script
### The working directory should be the directory containing the agentify_script.py script
github_repo_name=$1
github_repo=$2
host_project_dir='/mnt/midnight/steven_zhang/LLM_assisted_compilation'
server_pipeline_dir="$host_project_dir/server_pipeline"
files_before_script="$server_pipeline_dir/current_file_names.txt"
docker_project_dir='/app/server_pipeline'
files_after_script="$docker_project_dir/after_script_file_names.txt"
files_comparison_result="$docker_project_dir/new_files.txt"
bash_commands_generated_dir="$host_project_dir/bash_commands_generated/$github_repo_name/"

find "$server_pipeline_dir" -type f > $files_before_script # output_file is the path to the file containing the list of files to be copied to the container


container_id=$(sudo docker run -d -w /app sz904/llm_assisted_compilation:4 tail -f /dev/null)

sudo docker cp $server_pipeline_dir $container_id:/app/server_pipeline

## If repo existed, copy the repo to the container
# if [ -d "$host_project_dir/cloned_repos/$github_repo_name" ]; then
#     # Check if the .git directory exists inside the repository
#     if [ -d "$host_project_dir/cloned_repos/$github_repo_name/.git" ]; then
#         echo "Repository is cloned. Proceeding to copy it into the Docker container."

        # Copy the repository into the Docker container
        
sudo docker cp $host_project_dir/cloned_repos/$github_repo_name $container_id:/app/server_pipeline/cloned_repos/
#         echo "Repository copied to container at /app/server_pipeline/cloned_repos/ ."
#     else
#         echo "Directory exists but does not contain a valid Git repository."
#     fi
# else
#     echo "Repository directory does not exist at $host_project_dir/cloned_repos/$github_repo_name."
# fi

# 
# sudo docker cp $host_project_dir/cloned_repos/$github_repo $container_id:/app/server_pipeline/cloned_repos/ 


sudo docker exec -w /app/server_pipeline/ -it $container_id /bin/bash -c "python3.9 compilation.py --repo_url $github_repo"

# sudo docker exec -it $container_id /bin/bash -c "ls /app/server_pipeline/"

find "$docker_project_dir" -type f > "$files_after_script"
comm -13 "$files_before_script" "$files_after_script" > "$files_comparison_result"
mkdir -p ""
while IFS= read -r file; do
    cp "$file" "$bash_commands_generated_dir"
done < "$files_comparison_result"

sudo docker cp $container_id:/app/server_pipeline/autogen_logs/ /mnt/midnight/steven_zhang/LLM_assisted_compilation/autogen_logs/$github_repo_name/

sudo python3 $server_pipeline_dir/log_parse.py /mnt/midnight/steven_zhang/LLM_assisted_compilation/autogen_logs/

# read -p "Do you want to stop and remove the docker container? (yes/no): " user_input
# if [ "$user_input" == "yes" ]; then
#     echo "Exiting script."
    # sudo docker stop $container_id
    # sudo docker rm $container_id
# else
#     # wait for user to stop and remove the container
#     echo "Please stop and remove the docker container manually."
#     echo "Exiting script without stop and removing the docker container."
# fi
sudo docker stop $container_id
sudo docker rm $container_id