DEFAULT_VALUES = { ### Any default values that used from parsing arguments
    "HUMAN_IN_LOOP" : False,                                      # Human will act as the supervisor
    "MODEL_NAME" : 'o3-mini',
    "MAX_TOKENS" : 100000, # The max tokens possible for our API
    "API_KEY" : None,
    "TEMPERATURE" : 0,
    "OPERATING_SYSTEM" : 'Ubuntu',
    "GITHUB_REPO" : 'https://github.com/flipperdevices/flipperzero-firmware',
    "OPTIMIZATION_LEVEL" : 'O2',
    "SAVE_PATH" : '/app/compiled_repos/',        # NOTE: This will be the directory where the compiled files will be saved
    "LOG_DIR" : '/app/autogen_logs/',                                         # Repo name will be appended to this directory
    "VENV_DIR" : '/app/venv/',                                        # Repo name will be appended to this directory
    "SILENT" : False,                                            # Whether to print the chat messages or not
    "MAX_TURNS" : None,
    "PRINT_COST" : True,
    "TIMEOUT_BASH" : 60*60,                                      # In seconds
    "TIMEOUT_LLM" : 60,                                          # In seconds
    "SUDO_PASSWORD" : None,
    "IF_DOCKER_EXECUTOR" : False,
    "DOCKER_IMAGE" : "sz904/compilation_stage2_image:1",    
    "PROJECT_DIR" : None, 
    "AUTO_BUILD": False,
    "AGENTS_NUMBER" : 2,
    "RANDOM": 1,     
    "ARGS_SAVE_LOCATION": None, 
    "HOST_PROJECT_DIR": None,
    "TEST": False,
    "IMAGE_PULL_POLICY": True,
    "GITHUB_TOKEN" : None,    
    "STARTING_INDEX" : 1  ,                                      # 20 will be 22 in the sheet, -1 will run the GITHUB_REPO
    "ENDING_INDEX" : -1,    
    "CORES": 15,
    "K8S-PARALLELISM": 1,    
    "BACKOFF_LIMIT": 100, 
    "REFINE_TIMES": 3,
    "RETRIEVAL": True,
    
    ### Any hard coded values that are not supposed to be changed
    # "DATA_PATH" : '/mnt/midnight/steven_zhang/LLM_assisted_compilation/Compilation_Benchmark/data/all_open_sourced_data/sampled_repos_385_cleaned_higher_split.jsonl',
    "DATA_PATH" : "/mnt/midnight/steven_zhang/LLM_assisted_compilation/Compilation_Benchmark/data/all_open_sourced_data/sampled_repos_149_cleaned_higher_split_compilable.jsonl",
    "COLUMN_NAME" : 'Github_Url',
    "CLONED_DIR" : "/app/cloned_repos",
    "COMPILED_DIR" : "/app/compiled_repos",
    "K8S_COMPILED_DIR" : "/app/k8s_compiled_repos",
    "RESULTS_DIR" : "/app/compiled_results",
    "AUTOGEN_LOGS_DIR" : "/app/autogen_logs",
    "ALL_LOGS_DIR" : "/app/all_logs",
    "accepted_licenses" : [
        "MIT",
        "Apache-2.0",
        "BSD-2-Clause",
        "BSD-3-Clause",
        "CC0-1.0",
        "Unlicense"
    ],
    }