

import json
import os
import editdistance


def cal_whole_CER(data):
    total_distance = 0
    total_length = 0
    for line in data:
        pred = line['pred']
        gt = line['gt']
        distance = editdistance.eval(pred,gt)
        total_distance += distance
        total_length += len(gt)
    return total_distance/total_length

data = json.load(open("sft-error-fix/generated_predictions.jsonl","r"))
print(cal_whole_CER(data))