"""
Core module for preference-based reinforcement learning experiments.

This module contains the main experiment runner and learning algorithms.
"""

from .experiment_runner import run_experiment, run_experiment_multiprocessing
from .offline_learning import offline_learning
from .online_learning import online_learning
from .parser import print_config, parse_args

__all__ = [
    "run_experiment",
    # "run_experiment_multiprocessing",
    "offline_learning",
    "online_learning",
    "print_config",
    "parse_args",
]
