"""Task registry and base exports.

Import concrete tasks here so their `@register_task` decorators execute on
package import (explicit registration like the original scripts).
"""

from .base import Task, register_task, get_task
from . import equivalent  # noqa: F401  (ensures 'equivalent' is registered)
from . import independent  # noqa: F401  (ensures 'independent' is registered)
from . import complementary  # noqa: F401  (ensures 'complementary' is registered)
from . import contradictory  # noqa: F401  (ensures 'contradictory' is registered)
from . import alternative  # noqa: F401  (ensures 'alternative' is registered)
from . import entailment  # noqa: F401  (ensures 'entailment' is registered)
from . import recognition  # noqa: F401  (ensures 'entailment' is registered)

__all__ = [
    "Task",
    "register_task",
    "get_task",
]
