# Invariant Convolutional Layers for Time Series
## Source code for Classification and Anomaly detection experiments for univariate/multivariate series 
## Implementations for the proposed **InvConvNet** (with standard and invariant convolutions) and vanilla CNN baselines (with standard convolutions), including **Inception**, **ResNet**, **CNN** .
Models can be found in the `./models` folder and layers in `./layers`. The spripts with the train loops for classification and anomaly detection can be found in `./exp` folder. You can add additional models layers by following the standard format of the example code and adding the names of the models in `./exp/exp_basic.py` and their implementations in `./models`.

### Datasets
You can download the datasets from the following public sources and add them in the `./dataset` folder:
- **UCR** and **UEA** classification datasets can be found at https://www.timeseriesclassification.com.
- **UCIHAR**, **Sleep-EDF**, **Epilepsy** and **Fault-Diagnosis** datasets are available at the official github repo of TS-TCC method (Time-Series Representation Learning via Temporal and Contextual Contrasting, IJCAI-21).
- Anomaly detection datasets are obtained by Time-Series-Library official github repo (TimesNet: Temporal 2D-Variation Modeling for General Time Series Analysis, ICLR 2023). Similarly, the implementations of the rest baselines used in this work can be found in that repo.

### Experiments
In python3.8, you first need to install the required libraries:

`pip install -r requirements.txt`

Classification experiments (**InvConvNet**):

`bash ./train_uea_invconv.sh`

`bash ./train_restclass_invconv.sh`

Classification experiments (**Vanilla CNN baselines**):

`bash ./train_uea_inception.sh`

`bash ./train_uea_resnet.sh`

`bash ./train_uea_conv.sh`

`bash ./train_restclass_cnnbaselines.sh`

Anomaly Detection experiments (**InvConvNet**):

`bash ./train_anodet_invconv.sh`

Anomaly Detection experiments (**Vanilla CNN baselines**):

`bash ./train_anodet_inception.sh`

`bash ./train_anodet_resnet.sh`

`bash ./train_anodet_conv.sh`
