#!/bin/bash

MODEL=${MODEL:-"mistralai/Mistral-7B-v0.1"}

for seed in 42 2025 2024 2023 2022; do
  CUDA_VISIBLE_DEVICES=0 python train_bhra_arithmetic.py \
    --model "$MODEL" \
    --lora_r 4 \
    --lora_alpha 32 \
    --num_blocks_out 8 \
    --num_blocks_in 8 \
    --target_modules q_proj k_proj v_proj o_proj gate_proj up_proj down_proj \
    --lr 2e-3 \
    --seed $seed
done
