Here are six datasets corresponding to the six Learning from Demonstration (LfD) tasks listed in our paper, with the following correspondence relationships:

`basket_package_file_wo_img.pkl` -> `Basket-Pick-Place`, which have 18436 frames in total.

`boxing_package_file_wo_img.pkl` -> `Boxing`, which have 11118 frames in total.

`hammer_package_file_wo_img.pkl` -> `Hammer-Catch`, which have 12759 frames in total.

`rps_package_file_wo_img.pkl` -> `Rock-Paper-Scissors`, which have 9380 frames in total.

`squat_package_file_wo_img.pkl` -> `Squat`, which have 8535 frames in total.

`trash_package_file_wo_img.pkl` -> `Catch-Release`, which have 13234 frames in total.

We exclude all the images for the supplementary due to file size limit. We visualize the ~10s images (8x) for all 6 tasks in OmniH2O-FOV-samples_8x.mp4

Our dataset comprises several components including `rgb images`, `root positions`, `root quaternion`, `motion goal positions`, `motion goal velocities`, `depth images`, `wrist actions`, and `finger actions`. Below is a Python code snippet demonstrating how to utilize this dataset:

```python
import pickle
# load dataset from the pkl file
with open('pkl_file_you_want', 'rb') as file:
    data = pickle.load(file)
# process the data to different part
rgb_image_set, root_position_set, root_quaternion_set, motion_goal_position_set, motion_goal_velocity_set, depth_image_set, wrist_action_set, finger_action_set = [], [], [], [], [], [], [], []

for i in range(len(data)):
    rgb_image_set.append(data[i]['img']) # data[i]['img'] is a numpy array shaped (240, 424, 3) # we exclude all the images for the supplementary due to file size limit. We visualize the ~10s images (8x) for all 6 tasks in OmniH2O-FOV-samples_8x.mp4
    root_position_set.append(data[i]['root_pos']) # data[i]['root_pos'] is a numpy array shaped (3,) # (x, y, z)
    root_quaternion_set.append(data[i]['root_quat']) # data[i]['root_quat'] is a numpy array shaped (4,) # (x, y, z, w)
    motion_goal_position_set.append(data[i]['ref_body_pos']) # data[i]['ref_body_pos'] is a numpy array shaped (9,) 
    motion_goal_velocity_set.append(data[i]['ref_body_vel']) # data[i]['ref_body_vel'] is a numpy array shaped (9,) 
    depth_image_set.append(data[i]['depth']) # data[i]['idepthmg'] is a numpy array shaped (240, 424) 
    wrist_action_set.append(data[i]['wrist']) # data[i]['wrist'] is a numpy array shaped (2,) # left wrist, right wrist
    finger_action_set.append(data[i]['finger']) # data[i]['finger'] is a numpy array shaped (12,) # left hand, right hand, each hand have 6 DoF where thumb have two DoF. (little finger, ring finger, middle finger, index finger, thumb1, thumb2)
```