#!/bin/bash
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --gpus=1
#SBATCH --cpus-per-task=18
#SBATCH -t 1-0
#SBATCH --output=outputs/logs/inr_cls_tf_no_mod_2_pt2_epoch_100
#SBATCH --open-mode=append
#SBATCH --partition=gpu


module load 2022
module load Anaconda3/2022.05
# module load CUDA/11.3.1

source $HOME/.bashrc
conda activate dwsnets2

echo "=================================="
echo "Date: $(date)"
echo "Directory: $(pwd)"
python -c 'import torch; print(torch.randn(1).cuda())'

EXTRA_ARGS=$@
echo "Extra args: $EXTRA_ARGS"
srun python -u experiments/inr_classification/main.py seed=2 model=rttransformer data=mnist n_epochs=100 \
  data.train.augmentation=True model.kwargs.num_probe_features=0 \
  model.kwargs.dropout=0.5 model.kwargs.use_pos_embed=True \
  wandb.name=mnist_rt_no_mod model.kwargs.modulate_v=False
