#!/bin/bash
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --gpus=1
#SBATCH --cpus-per-task=18
#SBATCH -t 1-0
#SBATCH --output=outputs/logs/mnist_dilation_pna_seed_2_epoch_200_rev_edge_0.2drop_128d_0pf
#SBATCH --open-mode=append
#SBATCH --partition=gpu


module load 2022
module load Anaconda3/2022.05
# module load CUDA/11.3.1

source $HOME/.bashrc
conda activate dwsnets2

echo "=================================="
echo "Date: $(date)"
echo "Directory: $(pwd)"
python -c 'import torch; print(torch.randn(1).cuda())'

EXTRA_ARGS=$@
echo "Extra args: $EXTRA_ARGS"
srun python -u experiments/mnist/main.py seed=2 model=pna data=mnist n_epochs=200 \
  model.kwargs.num_probe_features=0 model.kwargs.gnn_kwargs.dropout=0.2 \
  wandb.name=mnist_dilation_pna_seed_2_epoch_200_rev_edge_0.2drop_128d_0pf \
  model.kwargs.rev_edge_features=True $EXTRA_ARGS
