#!/bin/bash

# Function to handle SIGINT (Ctrl+C)
handle_interrupt() {
    # Kill all child processes
    pkill -P $$
}

trap handle_interrupt SIGINT

# Ensure at least two arguments are passed
if [ "$#" -lt 2 ]; then
  echo "Usage: $0 <CUDA_DEVICE_RANGE> <SEED_RANGE> [additional arguments for main.py...]"
  exit 1
fi

# Extract the device and seed ranges
DEVICE_RANGE=$1
SEED_RANGE=$2
shift 2  # Remove the first two arguments, so $@ only contains the remaining arguments

# Parse the CUDA device range
IFS='-' read -ra DEVICE_ARR <<< "$DEVICE_RANGE"
START_DEVICE=${DEVICE_ARR[0]}
END_DEVICE=${DEVICE_ARR[1]}

# Parse the seed range
IFS='-' read -ra SEED_ARR <<< "$SEED_RANGE"
START_SEED=${SEED_ARR[0]}
END_SEED=${SEED_ARR[1]}

# Loop through the devices and seeds together
for (( device=$START_DEVICE, seed=$START_SEED; device<=$END_DEVICE && seed<=$END_SEED; device++, seed++ )); do
  CUDA_VISIBLE_DEVICES=$device python main.py seed=$seed $@ &
done

# Wait for all processes to finish
wait