#!/bin/bash
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --gpus=1
#SBATCH --cpus-per-task=18
#SBATCH -t 1-0
#SBATCH --output=outputs/logs/cnn_gen_pna_pe_seed_2_epoch_200_aug_d_hid_512
#SBATCH --open-mode=append
#SBATCH --partition=gpu


module load 2022
module load Anaconda3/2022.05
# module load CUDA/11.3.1

source $HOME/.bashrc
conda activate dwsnets2

echo "=================================="
echo "Date: $(date)"
echo "Directory: $(pwd)"
python -c 'import torch; print(torch.randn(1).cuda())'

EXTRA_ARGS=$@
echo "Extra args: $EXTRA_ARGS"
cd experiments/cnn_generalization
echo `ls`
srun python -u main.py seed=2 model=pna data=zoo_cifar_nfn n_epochs=200 \
  data.train.augmentation=True model.num_probe_features=0 \
  model.use_pos_embed=True  wandb.name=cnn_gen_pna_pe_seed_2_epoch_200_aug_d_hid_512 \
  model.d_hid=512 batch_size=256 distributed=False $EXTRA_ARGS
