#!/bin/bash
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --gpus=1
#SBATCH --cpus-per-task=18
#SBATCH -t 1-0
#SBATCH --output=outputs/logs/cnn_gen_rt_mod_pe_seed_2_epoch_200_drop_0.2_double
#SBATCH --open-mode=append
#SBATCH --partition=gpu


module load 2022
module load Anaconda3/2022.05
# module load CUDA/11.3.1

source $HOME/.bashrc
conda activate dwsnets2

echo "=================================="
echo "Date: $(date)"
echo "Directory: $(pwd)"
python -c 'import torch; print(torch.randn(1).cuda())'

EXTRA_ARGS=$@
echo "Extra args: $EXTRA_ARGS"
cd experiments/cnn_generalization
echo `ls`
srun python -u main.py seed=2 model=rtransformer data=zoo_cifar_nfn n_epochs=200 \
  data.train.augmentation=True model.num_probe_features=0 \
  model.dropout=0.2 model.use_pos_embed=True \
  model.modulate_v=True wandb.name=cnn_gen_rt_mod_pe_seed_2_epoch_200_drop_0.2_double \
  model.d_node=128 model.d_edge=64 model.d_attn_hid=256 model.d_node_hid=256 \
  model.d_edge_hid=128 model.d_out_hid=256 \
  batch_size=128 model.linear_as_conv=False distributed=False $EXTRA_ARGS


