#!/bin/bash
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --gpus=1
#SBATCH --cpus-per-task=18
#SBATCH -t 1-0
#SBATCH --output=outputs/logs/fmnist_inr_cls_rt_mod_pe_seed_2_epoch_200_drop_0.2
#SBATCH --open-mode=append
#SBATCH --partition=gpu


module load 2022
module load Anaconda3/2022.05
# module load CUDA/11.3.1

source $HOME/.bashrc
conda activate dwsnets2

echo "=================================="
echo "Date: $(date)"
echo "Directory: $(pwd)"
python -c 'import torch; print(torch.randn(1).cuda())'

EXTRA_ARGS=$@
echo "Extra args: $EXTRA_ARGS"
cd experiments/inr_classification
echo `ls`
srun python -u main.py seed=2 model=rtransformer data=fmnist n_epochs=200 \
  data.train.augmentation=True model.num_probe_features=0 \
  model.dropout=0.2 model.use_pos_embed=True \
  model.modulate_v=True wandb.name=fmnist_inr_cls_rt_mod_pe_seed_2_epoch_200_drop_0.2 \
  $EXTRA_ARGS
