#!/bin/bash
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --gpus=1
#SBATCH --cpus-per-task=18
#SBATCH -t 12:00:00
#SBATCH --output=outputs/logs/mnist_cls_rt_mod_pe_no_aug_seed_2_epoch_200_mixup
#SBATCH --open-mode=append
#SBATCH --partition=gpu


module load 2022
module load Anaconda3/2022.05
# module load CUDA/11.3.1

source $HOME/.bashrc
conda activate dwsnets2

echo "=================================="
echo "Date: $(date)"
echo "Directory: $(pwd)"
python -c 'import torch; print(torch.randn(1).cuda())'

EXTRA_ARGS=$@
echo "Extra args: $EXTRA_ARGS"
srun python -u experiments/inr_classification/main.py seed=2 model=rttransformer data=mnist  n_epochs=200 \
  data.train.augmentation=False model.kwargs.num_probe_features=0 \
  model.kwargs.dropout=0.0 model.kwargs.use_pos_embed=True \
  model.kwargs.modulate_v=True wandb.name=mnist_cls_rt_mod_pe_seed_2_epoch_200_mixup \
  mixup=True $EXTRA_ARGS

