# Graph Neural Networks for Learning Equivariant Representations of Neural Networks

Official implementation for
<pre>
<b>Graph Neural Networks for Learning Equivariant Representations of Neural Networks</b>
Anonymous
<em>Submitted to ICLR 2024</em>
</pre>

Our implementation follows the block structure as described in the paper.

![](misc/blocks.png)

## Setup environment

To run the experiments, first create clean virtual environment and install the requirements.

```bash
conda create -n dwsnets python=3.9
conda activate dwsnets
conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 cudatoolkit=11.3 -c pytorch
```

Install the repo:

```bash
git clone https://github.com/AvivNavon/DWSNets.git
cd DWSNets
pip install -e .
```

## Introduction Notebook
An introduction notebook for INR classification with DWSNets:
[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/AvivNavon/DWSNets/blob/main/notebooks/mnist-inr-classification.ipynb)

## Run experiment

To run specific experiment, please follow the instructions in the README file within each experiment folder.
It provides full instructions and details for downloading the data and reproducing the results reported in the paper.
### Dataset
**The datasets are available [here](https://www.dropbox.com/sh/56pakaxe58z29mq/AABtWNkRYroLYe_cE3c90DXVa?dl=0).**
- [Sine regression INRs](https://www.dropbox.com/sh/56pakaxe58z29mq/AABtWNkRYroLYe_cE3c90DXVa?dl=0&preview=sine-regression-inrs.zip)
- [MNIST INRs](https://www.dropbox.com/sh/56pakaxe58z29mq/AABtWNkRYroLYe_cE3c90DXVa?dl=0&preview=mnist-inrs.zip)
- [SSL INRs](https://www.dropbox.com/sh/56pakaxe58z29mq/AABtWNkRYroLYe_cE3c90DXVa?dl=0&preview=ssl-inrs.zip)
