#!/bin/bash

# Define the list of options
options=(0 1 2)

# Define the Python function
python_function() {
    # Retrieve the argument passed to the Python function
    argument=$1

    # Retrieve additional command line arguments
    additional_args="${@:2}"

    echo "Running command: python main.py seed=$argument $additional_args"
    
    # Call your Python script with the argument
    python main.py seed=$argument $additional_args
}

# Iterate over the options and call the Python function
for option in "${options[@]}"
do
    python_function "$option" "$@"
done