<!-- >📋  A template README.md for code accompanying a Machine Learning paper -->

## Requirement

To install requirements:

```setup
pip install -r requirements.txt
```


## Training

To train the model(s) in the paper, run main.py(load the whole dataset) or main_three_parts.py(load three interest parts). We provide the explanations of each argument. We provide the detailed hyperparameters in run.sh.
```
python main.py --dataset_path [PATH] --cache_dir [cache_PATH] --dataset [split]  --length_input [Lookback]  --length_output [Prediction] \
 --method [model-name] --lr [learning_rate] --weight_decay [Regularization] --epoches [train-epoch] --bachsize [B] --store [Store-model-dict] \
 --device [device] --seed [seed]
```
- **dataset_path**: the dir path of dataset
- **cache_dir**: the dir for save the model state dict
- **length_input**: the length of lookback window
- **length_output**: the length of prediction
- **method**: which architecture, “mlp,tcn,gcn,lstm” for the whole dataset, "mlp,tcn,gcn,lstm,NLinear,TSMixer,GPT4TS,AutoTimes,DeepAR,DilatedRNN,stemGNN,FourierGNN,ModernTCN,Timesnet,PatchTST,iTransformer" for the three parts dataset
- **lr**: learning rate 
- **weight_decay**: regularization weight
- **epoches**: training epoches
- **bachsize**: batch size
- **store**: store the model state dict or not 
- **device**: cpu or cuda
- **seed**: random seeds

<!-- >📋  Describe how to train the models, with example commands on how to train the models in your paper, including the full training procedure and appropriate hyperparameters. -->

## Evaluation

To evaluate the model, the eval.py can be used. Notably, in training main.py/main_three_parts.py, the evaluation results are also available. We provide some pretrain state dict for reproduce our results. 
```eval
python eval.py --dataset_path [PATH] --cache_dir [cache_PATH] --dataset [split]  --length_input [Lookback]  --length_output [Prediction] \
 --bachsize [B] --method [model-name] --device [device] --seed [seed]
```

<!-- >📋  Give a link to where/how the pretrained models can be downloaded and how they were trained (if applicable).  Alternatively you can have an additional column in your results table with a link to the models. -->

## Results

The detailed results are provided in our paper. The part benchmark results on three interest parts:

![image](pics/mae_mse.PNG)

![image](pics/SEDI.PNG)


