import numpy as np

class ObjectiveFunction:
    def __init__(self, input_dims: int , num_objectives: int , num_constraints: int):
        self.input_dims = input_dims
        self.num_objectives = num_objectives
        self.num_constraints = num_constraints
        self.bounds = np.array([(0.0, 1.0)] * input_dims)  # Default bounds
        self.ref_point = None
        self.evaluator = None

    def __call__(self, x: np.ndarray):
        raise NotImplementedError("This method should be overridden by subclasses.")