#!/bin/sh

conda init bash
conda activate mobo-osd

for batch in 1 4 8 10; do
for seed in {1..10}; do
  for objective in dtlz2; do
    for m in 2 3 4; do
      python test-mobo-osd.py -f $objective -d 5 -m $m -b $batch -n 200 --n_beta 20 --seed $seed 
    done
  done
  for objective in vlmop2 zdt1 speed-reducer car-impact marine-design water-planning; do
    python test-mobo-osd.py -f $objective -d 5 -b $batch -n 200 --n_beta 20 --seed $seed
  done
done
done