export CUDA_VISIBLE_DEVICES=0


$DATA_PATH=$1
$CKPT_PATH=$2
$WORK_DIR=$3
$OUTPUT_FILE=$4

python -m torch.distributed.launch --nproc_per_node=1 src/gpt2_beam.py \
    --data $DATA_PATH \
    --batch_size 1 \
    --seq_len 512 \
    --eval_len 64 \
    --model_card gpt2.md \
    --init_checkpoint $CKPT_PATH \
    --platform local \
    --lora_dim 4 \
    --lora_alpha 32 \
    --beam 10 \
    --length_penalty 0.8 \
    --no_repeat_ngram_size 4 \
    --repetition_penalty 1.0 \
    --eos_token_id 628 \
    --work_dir $WORK_DIR \
    --output_file $OUTPUT_FILE
