use vstd::{prelude::*};

verus! {

spec fn uninterp_fn(x: u64) -> bool;

//Require that all elements in the vector t satisfy uninterp_fn. The element y also satisfy uninterp_fn. Push the element into the vector.
fn push_test(t: Vec<u64>, y: u64)
    requires
        forall|i: int| #![auto] 0 <= i < t.len() ==> uninterp_fn(t[i]),
        uninterp_fn(y),
{
    let mut t = t;
    t.push(y);

    assert(
        forall|i: int| #![auto] 0 <= i < t.len() ==> uninterp_fn(t[i])
    );
}

} // verus!

fn main() { }

