method SetToSeq<T>(s: set<T>) returns (xs: seq<T>)
  ensures multiset(s) == multiset(xs)
  ensures forall i::0<=i<|xs|-1 ==> xs[i] != xs[i+1]
{
  xs := [];
  var left: set<T> := s;
  while left != {}
    invariant multiset(left) + multiset(xs) == multiset(s)
  {
    var x :| x in left;
    left := left - {x};
    xs := xs + [x];
  }
}
