use vstd::{prelude::*};

verus! {

spec fn uninterp_fn(x: u64) -> bool;

//Require that the input vector contains at least one element and all elements in the vector already satsify uninterp_fn. Pop an element from the tail.
fn pop_test(t: Vec<u64>)
    requires
        t.len() > 0,
        forall|i: int| #![auto] 0 <= i < t.len() ==> uninterp_fn(t[i]),
{
    let mut t = t;
    let x = t.pop().unwrap();

    assert(uninterp_fn(x));
    assert(forall|i: int| #![auto] 0 <= i < t.len() ==> uninterp_fn(t[i]));
}

} // verus!

fn main() { }
