

#ifndef __LC_CLOCK_H__
#define __LC_CLOCK_H__

#ifdef __cplusplus
extern "C" {
#endif

enum LC_ClockType
{
   LC_CLOCKTYPE_CPU     = 1,                 /**< use CPU clock */
   LC_CLOCKTYPE_WALL    = 2                  /**< use wall clock */
};
typedef enum LC_ClockType LC_CLOCKTYPE;      /**< clock type to use */

/** CPU clock counter */
struct LC_CPUClock
{
   clock_t               user;               /**< clock ticks for user CPU time */
};
typedef struct LC_CPUClock LC_CPUCLOCK;

/** wall clock counter */
struct LC_WALLClock
{
   long                  sec;                /**< seconds counter */
   long                  usec;               /**< microseconds counter */
};
typedef struct LC_WALLClock LC_WALLCLOCK;

/** clock timer */
struct LC_Clock
{
   union
   {
      LC_CPUCLOCK        cpuclock;           /**< CPU clock counter */
      LC_WALLCLOCK       wallclock;          /**< wall clock counter */
   } data;
   int                   nruns;              /**< number of SCIPclockStart() calls without SCIPclockStop() calls */
   LC_CLOCKTYPE          clocktype;          /**< current type of clock used */
};
typedef struct LC_Clock LC_CLOCK;            /**< clock timer */


/** creates a clock and initializes it */
extern
LC_CLOCK* LC_clockCreate(void);

/** frees a clock */
extern
void LC_clockFree(
   LC_CLOCK**            clck                /**< pointer to clock timer */
   );

/** sets the type of the clock */
extern
void LC_clockSetType(
   LC_CLOCK*             clck,               /**< clock timer */
   LC_CLOCKTYPE          clocktype           /**< type of clock */
   );

/** completely stop the clock and reset the clock's counter to zero */
extern
void LC_clockReset(
   LC_CLOCK*             clck                /**< clock timer */
   );

/** starts measurement of time in the given clock, update the clock's type if it is bound to the default type */
extern
void LC_clockStart(
   LC_CLOCK*             clck                /**< clock timer */
   );

/** stops measurement of time in the given clock */
extern
void LC_clockStop(
   LC_CLOCK*             clck                /**< clock timer */
   );

/** gets the used time of this clock in seconds */
extern
double LC_clockGetTime(
   LC_CLOCK*             clck                /**< clock timer */
   );

#ifdef __cplusplus
}
#endif

#endif
