#ifndef _FW_LMO_H_
#define _FW_LMO_H_

#include <cstdint>
#include <vector>
#include <unordered_map>

#include <scip/scip.h>
#include <Eigen/Dense>

template<typename val_t>
using vec_t = Eigen::VectorX<val_t>;

template<typename ix_t, typename val_t>
class KnapsackOracle
{
public:
   KnapsackOracle(
      SCIP*                        scip,       // scip instance
      const int                    dim,        // dimension of knapsack
      const vec_t<SCIP_Longint>&   weights,    // integer weights of knapsack
      const SCIP_Longint           capacity    // capacity of knapsack
      );
   ~KnapsackOracle();

   //! linear maximization in given direction with resulting vertex
   val_t operator()(
      const vec_t<val_t>& direction,
      vec_t<val_t>&       vertex
      );

protected:
   SCIP*               m_scip;
   const int           m_dim;
   const vec_t<SCIP_Longint> m_weights;
   const SCIP_Longint  m_capacity;
};

#endif // _FW_LMO_H_
