#ifndef _LMO_API_H_
#define _LMO_API_H_

#include <scip/def.h>
#include <scip/scip.h>

#ifdef __cplusplus
extern "C" {
#endif

/** maximize linear function in given direction over Knapsack problem with resulting vertex */
extern
double callKnapsackOracle(
   SCIP*                        scip,        // scip instance
   const int                    dim,         // dimension of knapsack
   const SCIP_Longint*          weights,     // integer weights of knapsack
   const SCIP_Longint           capacity,    // capacity of knapsack
   const double*                direction,   // linear objective
   double*                      vertex       // vector of resulting vertex
   );

#ifdef __cplusplus
}
#endif

#endif // _LMO_API_H_
