#ifndef _SCALAR_FW_TYPES_H_
#define _SCALAR_FW_TYPES_H_

#include <functional>

#include <Eigen/Dense>
#include <limits>

using namespace Eigen;

template<typename val_t>
using vec_t = Eigen::VectorX<val_t>;

template<typename val_t>
using mat_t = Eigen::Matrix<val_t, Eigen::Dynamic, Eigen::Dynamic, Eigen::RowMajor>;

template<typename ix_t, typename val_t>
using fun_t = std::function<val_t(const vec_t<val_t>&)>;

template<typename ix_t, typename val_t>
using ip_fun_t = std::function<void(vec_t<val_t>&, const vec_t<val_t>&)>;

#define INVALID_T std::numeric_limits<ix_t>::max()

#endif // _SCALAR_FW_TYPES_H_
