#include "lmo_api.h"
#include "lmo.h"
#include "lmo.impl.h"

/** maximize Knapsack linear oracle in given direction with resulting vertex */
double callKnapsackOracle(
   SCIP*                        scip,       // scip instance
   const int                    dim,        // dimension of knapsack
   const SCIP_Longint*          weights,    // integer weights of knapsack
   const SCIP_Longint           capacity,   // capacity of knapsack
   const double*                direction,   // linear objective
   double*                      vertex       // vector of resulting vertex
   )
{
   using ix_t = uint64_t;
   using val_t = double;
   using lmo_t = KnapsackOracle<ix_t, val_t>;

   vec_t<SCIP_Longint> w(dim);
   vec_t<double> d(dim);
   for (int i = 0; i < dim; ++i)
   {
      w[i] = weights[i];
      d[i] = direction[i];
   }

   lmo_t lmo(scip, dim, w, capacity);

   vec_t<double> v(dim);

   val_t optval = lmo(d, v);

   for (int i = 0; i < dim; ++i)
      vertex[i] = v[i];

   return optval;
}
