import torch
import torch.nn as nn
import torch.nn.functional as F


class RelativeL2Loss(nn.Module):
    def __init__(self, eps=1e-8):
        super().__init__()
        self.eps = eps

    def forward(self, pred, target, reduction="mean"):
        assert reduction == "none"
        # calculate norm over each individual dimension
        target_norm = target.unsqueeze(-1).norm(p=2, dim=-1)
        target_norm[target_norm == 0.] = self.eps
        delta_norm = (pred - target).unsqueeze(-1).norm(p=2, dim=-1)
        return delta_norm / target_norm
