import pandas as pd

from SEPAL import SEPAL_DIR


def delete_exp(ids):
    # Load data
    scores = pd.read_parquet(SEPAL_DIR / "downstream_scores.parquet")
    val_lp_scores = pd.read_parquet(SEPAL_DIR / "val_lp_scores.parquet")
    test_lp_scores = pd.read_parquet(SEPAL_DIR / "test_lp_scores.parquet")
    checkpoints = pd.read_parquet(SEPAL_DIR / "checkpoints_sepal.parquet")

    # Remove lines
    scores = scores[~scores.id.isin(ids)].reset_index(drop=True)
    val_lp_scores = val_lp_scores[~val_lp_scores.id.isin(ids)].reset_index(drop=True)
    test_lp_scores = test_lp_scores[~test_lp_scores.id.isin(ids)].reset_index(drop=True)
    checkpoints = checkpoints[~checkpoints.id.isin(ids)].reset_index(drop=True)

    # Save data
    scores.to_parquet(SEPAL_DIR / "downstream_scores.parquet")
    val_lp_scores.to_parquet(SEPAL_DIR / "val_lp_scores.parquet")
    test_lp_scores.to_parquet(SEPAL_DIR / "test_lp_scores.parquet")
    checkpoints.to_parquet(SEPAL_DIR / "checkpoints_sepal.parquet")

    ## Delete embeddings files

    folder_path = SEPAL_DIR / "embeddings"
    files = folder_path.iterdir()

    # Iterate through the files
    for file in files:
        # Check if any id is present in the file name
        if any(embed_id in file.name for embed_id in ids):
            # Delete the file
            file.unlink()
            print(f"Deleted: {file.name}")

    return


ids = [
]
