import re

# Define regular expressions
prefixes = re.compile("@")
quotes = re.compile("[\"]")
ns = "http://rdf.freebase.com/ns/"
xml = "http://www.w3.org/2001/XMLSchema"
re_ns_ns = "^\<{0}[mg]\.[^>]+\>\t\<{0}[^>]+\>\t\<{0}[^>]+\>\t.$".format(ns)
re_ns_en = "^\<{0}[mg]\.[^>]+\>\t\<{0}[^>]+\>\t[\'\"](?!/).+[\'\"](?:\@en)?\t\.$".format(ns)
re_ns_xml = "^\<{0}[mg]\.[^>]+\>\t\<{0}[^>]+\>\t.+\<{1}\#[\w]+\>\t.$".format(ns, xml)

# Define file paths
input_file_path = ''  # Replace with your input file path
output_file_path = ''   # Replace with your output file path
error_file_path = ''  # Replace with your error file path

line_number = 0

# Open files for reading and writing
with open(input_file_path, 'r') as infile, \
     open(output_file_path, 'w') as outfile, \
     open(error_file_path, 'w') as errfile:

    for line in infile:
        line_number += 1
        line = line.rstrip()
        if line == "":
            outfile.write('\n')
        elif prefixes.match(line):
            outfile.write(line + '\n')
        elif line[-1] != ".":
            errfile.write("No full stop: skipping line %d\n" % (line_number))
            continue
        else:
            parts = line.split("\t")
            if len(parts) != 4 or parts[0].strip() == "" or parts[1].strip() == "" or parts[2].strip() == "":
                errfile.write("n tuple size != 3: skipping line %d\n" % (line_number))
                continue

            if re.search(re_ns_en, line):
                outfile.write(line + "\n")
            elif re.search(re_ns_ns, line):
                outfile.write(line + "\n")
            elif re.search(re_ns_xml, line):
                outfile.write(line + "\n")

        if line_number % 1000000 == 0:
            errfile.flush()
