import json
from SPARQLWrapper import SPARQLWrapper, JSON

SPARQLPATH = "http://localhost:8890/sparql"

def test():
    try:
        sparql = SPARQLWrapper(SPARQLPATH)
        sparql_txt = """
PREFIX ns: <http://rdf.freebase.com/ns/>

SELECT ?name WHERE {
  VALUES ?entity {ns:m.0kpv11}
  ?entity ns:type.object.name ?name .
  FILTER(LANG(?name) = "en")
}
        """
        #print(sparql_txt)
        sparql.setQuery(sparql_txt)
        sparql.setReturnFormat(JSON)
        results = sparql.query().convert()
        print(results)
    except:
        print('Your database is not installed properly !!!')

test()

a = ['1875–76 FA Cup', '1877–78 FA Cup', '1880–81 FA Cup', '1896–97 FA Cup', '1910–11 FA Cup', '1913–14 FA Cup', '1919–20 FA Cup', '1926–27 FA Cup', '1956–57 FA Cup', '1969–70 FA Cup', '1980–81 FA Cup', '1982–83 FA Cup', '1983–84 FA Cup', '1986–87 FA Cup', '1993–94 FA Cup', '1995–96 FA Cup', '1998–99 FA Cup', '2000–01 FA Cup', '2002–03 FA Cup', '2004–05 FA Cup']
b = "; ".join(a)
print(b)


def normalize_fractions_with_precision(fractions_list, precision=3):
    # 计算分数之和
    total_sum = sum(fractions_list)

    # 如果和为0，则不进行任何处理
    if total_sum == 0:
        return fractions_list

    # 如果和不为1，则进行归一化处理，并保留指定的小数位数
    if total_sum != 1:
        return [round(float(frac) / float(total_sum), precision) for frac in fractions_list]

    # 如果和已经是1，则直接返回原列表
    return fractions_list
a = [0, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1]
b = normalize_fractions_with_precision(a)
print(b)

reasons = [
    'Reason1: Kansas City is known for its vibrant arts scene, so exploring local museums and galleries could be a source of entertainment.',
    'Reason2: The city has a rich musical history, particularly in jazz and blues; attending live music performances might be a fun activity.',
]

# Removing the numbers from the reasons
modified_reasons = [reason.replace('Reason1:', 'Reason:').replace('Reason2:', 'Reason:').replace('Reason3:', 'Reason:') for reason in reasons]
print(modified_reasons)