from yacs.config import CfgNode as CN

_C = CN()
_C.SPIXEL = CN()
_C.SPIXEL.pretrained = '/your_path/SpixelNet_bsd_ckpt.tar'
_C.SPIXEL.downsize = 16
_C.SPIXEL.shift_unit = 1
_C.SPIXEL.k_means = 25
_C.SPIXEL.frame_resolution = 96
_C.SPIXEL.max_spread_scale = 5
_C.SPIXEL.num_k_means_steps = 100

def update_config(config, args):
    config.defrost()      
    for key in vars(args):
        setattr(config, key, eval(f'args.{key}'))        
    config.freeze()


def get_config(args):
    """Get a yacs CfgNode object with default values."""
    # Return a clone so that the defaults will not be altered
    # This is for the "local variable" use pattern
    config = _C.clone()
    update_config(config, args)

    return config