#!/bin/bash

# arguments
# 1: model_name
# 2: full name to json file

#SBATCH --job-name=collect_exem   # Job name
#SBATCH --ntasks=1                # Number of tasks (see below)
#SBATCH --nodes=1                 # Ensure that all cores are on one machine
#SBATCH --time=0-04:00            # Runtime in D-HH:MM
#SBATCH --partition=gpu-2080      # Partition to submit to
#SBATCH --mem=32G                 # Memory pool for all cores
#SBATCH --gres=gpu:1              # Request one GPU
#SBATCH --constraint=ImageNet2012 # Request a node that has ImageNet locally
#SBATCH --cpus-per-task=8         # Request all 8 CPUs

# include information about the job in the output
scontrol show job=$SLURM_JOB_ID

srun \
singularity exec \
--nv \
--bind /torch_models:/torch_models/ \
--bind ${1}:/output/ \
--bind /scratch_local/datasets/ImageNet2012/:/imagenet/ \
int_comp.sif \
./collect_exemplars.sh ${2} ${3}
echo DONE.