#!/bin/bash

# Script to collect multiple units in parallel (expected to be run on login node)
# Collect FVs for all units across num_gpus GPUs and collect exemplars.

# Calling this as ./3_start_exemplar_collection.sh output_221031 output_221031/units_resnet50_100_42_221031.json resnet50/resnet50-l2/googlenet

# read in output directory
output=${1}

# read in path of units file
unitsfile=${2}

# read in model name
model=${3}

if [ -z "${output}" ] || [ -z "${unitsfile}" ] || [ -z "${model}" ]; then
  echo "At least one of the inputs was empty! Model, output dir and unitsfile need to be specified! Aborting..."
  exit 1
fi

if [ ! -f "${unitsfile}" ]; then
  echo "Unitsfile ${unitsfile}.json does not exist! Aborting..."
  exit 1
fi

echo "Extracting exemplars for model ${model} and unit-file ${unitsfile}"
# record activations and extract exemplars for all units
sbatch run_collect_exemplars.sh ${output} ${model} ${unitsfile}

