#!/bin/bash
export CUDA_VISIBLE_DEVICES="0,1"
readonly MASTER_ADDR="127.0.0.1"
readonly MASTER_PORT="10356"
readonly MICRO_BATCH_SIZE=8
readonly GRADIENT_ACCUMULATION_STEPS=4
PWD="$(pwd)" && readonly PWD
PROJECT_DIR="$(dirname "${PWD}")" && readonly PROJECT_DIR
readonly RUN_PY="${PROJECT_DIR}/src/train.py"
readonly DS_CONFIG="${PROJECT_DIR}/script/ds_config.json"
readonly DATA_PATH="${PROJECT_DIR}/dataset/"
readonly MODEL_NAME_OR_PATH="/data/webgpt/models/chatglm3-6b"
readonly TOKENIZER_NAME_OR_PATH="/data/webgpt/models/chatglm3-6b"
cat <<EOT >"${DS_CONFIG}"
{
  "train_micro_batch_size_per_gpu": ${MICRO_BATCH_SIZE},
  "gradient_accumulation_steps": ${GRADIENT_ACCUMULATION_STEPS},
  "optimizer": {
    "type": "AdamW",
    "params": {
      "lr": 1e-5,
      "betas": [
        0.9,
        0.999
      ],
      "eps": 1e-8
    }
  },
  "scheduler": {
    "type": "WarmupDecayLR",
    "params": {
      "warmup_min_lr": 0,
      "warmup_max_lr": 1.0e-5,
      "warmup_num_steps": 200,
      "total_num_steps": 50000
    }
  },
  "fp16": {
    "enabled": true
  },
  "zero_optimization": {
    "stage": 2,
    "contiguous_gradients": true,
    "reduce_bucket_size": 1e7,
    "sub_group_size": 1e9
  },
  "gradient_clipping": 1.0,
  "wall_clock_breakdown": false,
  "prescale_gradients": false
}
EOT
echo ${MODEL_NAME_OR_PATH}
PYTHONPATH="${PROJECT_DIR}:${PYTHONPATH}" deepspeed --include localhost:"${CUDA_VISIBLE_DEVICES}"\
  --master_addr="${MASTER_ADDR}" \
  --master_port="${MASTER_PORT}" \
  "${RUN_PY}" \
  --tokenizer_path ${TOKENIZER_NAME_OR_PATH} \
  --data_path ${DATA_PATH} \
  --output_dir "${PROJECT_DIR}/output/"\
  --num_train_epochs 3 \
  --fp16 True \
  --per_device_train_batch_size ${MICRO_BATCH_SIZE} \
  --per_device_eval_batch_size ${MICRO_BATCH_SIZE} \
  --gradient_accumulation_steps ${GRADIENT_ACCUMULATION_STEPS} \
  --evaluation_strategy "no" \
  --eval_steps 0 \
  --eval_num 0 \
  --save_strategy "steps" \
  --save_steps 10 \
  --save_total_limit 2 \
  --learning_rate 1e-5 \
  --weight_decay 0. \
  --warmup_steps 200 \
  --logging_steps 1 \
  --report_to "none" \
  --model_max_length 512 \
  --model_name_or_path ${MODEL_NAME_OR_PATH} \
  --max_steps 50000 \
  --use_pipeline False \
  --deepspeed "${PROJECT_DIR}/script/ds_config.json" \
#  --warmup_ratio 0.03 \
# --lr_scheduler_type "cosine" \