# Multi-Level Stochastic Latent Noise Perturbation For Single Domain Generalization

## Introduction

Single domain generalization (SDG) is challenging because models trained on a single domain often suffer from out-of-distribution (OOD) shifts at inference time. Existing augmentation techniques often sacrifice semantic consistency for diversity or vice versa, and are largely confined to vision tasks. We propose a Stochastic Latent Noise Perturbation Module (SLNP) that automatically computes multiple MMD thresholds based on the source domain’s intra- and inter-class statistics, and then maximizes the sum of noise under these adaptive bounds. This unified objective generates diverse yet semantically faithful samples, applied independently of the downstream training loop—without requiring adversarial training or auxiliary loss terms. In addition, SLNP complements normalization methods, yielding synergistic improvements when the two are combined. Furthermore, our method is modality-agnostic and applicable to any distribution-based data. Experiments on image benchmark demonstrate that our approach integrates easily into existing pipelines and improves state-of-the-art SDG baselines, and additional results on speech data show its applicability beyond the vision domain. 

## Quickstart

### Installation

This project is fully tested under python 3.9.21. Set the environments with the following command.
```
pip install -r requirements.txt
```

### Data preparation

You can obtain the datasets from [StyDeSty] Official Github and [TAU](https://zenodo.org/records/3670167) Datasets. Then place the downloaded datasets under the folder `./datasets`

### Train and evaluate model

You can reproduce a experiment result with the code `./feature_s/scripts`.



## Results

Experiments on 3 real-world datasets demonstrate that SLNP achieves state-of-the-art performance when combined with existing normalization techniques and applicable in various distribution-based modalities.

