import torch.utils.data
import torchvision
import torchaudio
import os
import numpy as np
import bz2
import scipy.io
from torchvision import transforms
from PIL import Image
from torch.utils.data import Dataset
from torchaudio.transforms import MelSpectrogram, AmplitudeToDB
import pandas as pd
from tqdm import tqdm


import re
def save_tau_mels(root, domains='A,B,C,S1,S2,S3,S4,S5,S6', sr=16000, n_mels=256, out_dir=None):
    meta_path = os.path.join(root, 'meta.csv')
    meta = pd.read_csv(meta_path, sep=r"\s+", engine='python')

    # device name
    meta['device'] = meta['filename'].str.extract(r'-([abc]|s\d)\.wav$', flags=re.IGNORECASE)[0].str.upper()
    devices = [d.strip().upper() for d in domains.split(',')]
    meta = meta[meta['device'].isin(devices)]

    mel_tf = MelSpectrogram(
        sample_rate=sr, n_fft=2048, win_length=2048, hop_length=480,
        n_mels=n_mels, f_min=50, f_max=8000
    )
    db_tf = AmplitudeToDB()
    T = 400

    out_dir = out_dir or os.path.join(root, "mel_cache")
    os.makedirs(out_dir, exist_ok=True)

    for _, row in tqdm(meta.iterrows(), total=len(meta), desc="Caching log-mel"):
        fname = row['filename']
        wav_path = os.path.join(root, fname)
        out_path = os.path.join(out_dir, fname.replace('.wav', '.npy'))

        if os.path.exists(out_path):
            continue  # 이미 있으면 건너뜀

        wav, sr_real = torchaudio.load(wav_path)
        if sr_real != sr:
            wav = torchaudio.functional.resample(wav, sr_real, sr)
        mel = mel_tf(wav)
        mel_db = db_tf(mel)
        cur_len = mel_db.size(-1)
        if cur_len < T:
            pad = T - cur_len
            mel_db = torch.nn.functional.pad(mel_db, (0, pad))
        elif cur_len > T:
            mel_db = mel_db[:, :, :T]

        npy = mel_db.cpu().numpy()
        os.makedirs(os.path.dirname(out_path), exist_ok=True)
        with open(out_path, "wb") as f:
            np.save(f, npy)

    print(f"Saved all log-mel npy to {out_dir}")

save_tau_mels(
    root="/home/hyewon/datasets/TAU/TAU-urban-acoustic-scenes-2020-mobile-development",
    domains="A,B,C,S1,S2,S3,S4,S5,S6"
)