#!/bin/bash

eval "$(conda shell.bash hook)"
conda activate vci-env

DATA=$(cd -P -- "$(dirname -- "$0")" && pwd -P)

PYARGS=""
PYARGS="$PYARGS --name pendulum-test"
PYARGS="$PYARGS --data_name pendulum"
PYARGS="$PYARGS --data_path $DATA/data/pendulum"
PYARGS="$PYARGS --artifact_path $DATA/artifact"
PYARGS="$PYARGS --hparams hparams/hparams_pendulum.json"
PYARGS="$PYARGS --gpu 0" #PYARGS="$PYARGS --cpu"

PYARGS="$PYARGS --omega0 1.0"
PYARGS="$PYARGS --omega1 1.7"
PYARGS="$PYARGS --omega2 0.1"
PYARGS="$PYARGS --dist_outcomes bernoulli"
PYARGS="$PYARGS --dist_mode discriminate"

PYARGS="$PYARGS --max_epochs 500"
PYARGS="$PYARGS --batch_size 64"

python main.py $PYARGS
