# Variational Causal Inference

This repository is the official implementation of [**Variational Causal Inference**](*anonymized*).


## Installation

### 1. Create Conda Environment
```bash
conda config --append channels conda-forge
conda create -n vci-env --file requirements.txt
conda activate vci-env
```

### 2. Install Learning Libraries
- [Pytorch](https://pytorch.org/) [**1.13**.1](https://pytorch.org/get-started/previous-versions/)

  \* *make sure to install the right versions for your toolkit*


## Train
Once the environment is set up and the data are prepared, the function call to train the model is:

```bash
./all_morpho_experiments.sh &
```

A list of flags may be found in `all_morpho_experiments.sh` and `main.py` for experimentation with different network parameters. The run log and models are saved under `*artifact_path*/saves`, and the tensorboard log is saved under `*artifact_path*/runs`.

## Evaluate

Change `runs_to_check` in `morpho_gt_model_eval.py` to desired artifact run names, then run `morpho_gt_model_eval.py`.


## License

Contributions are welcome! All content here is licensed under the MIT license.
