import os
import pandas as pd
from PIL import Image
import numpy as np
from tqdm import tqdm

from vci.MorphoMNIST.morphomnist.measure import measure_image
from vci.morpho_gt_model_eval import get_intensity

def measure_folder(folder_path):
    image_data = {}

    for filename in tqdm(os.listdir(folder_path)):
        if filename.endswith(".png"):
            idx = int(filename.split(".")[0])
            file_path = os.path.join(folder_path, filename)
            image = Image.open(file_path)
            attrs = measure_image(image, verbose=False)
            intensity = get_intensity(np.array(image))

            attributes = {field: getattr(attrs, field) for field in attrs._fields}
            attributes["intensity"] = intensity

            image_data[idx] = attributes

    # Create a DataFrame from the list of image attributes
    df = pd.DataFrame.from_dict(image_data, orient='index').sort_index()

    parent_folder = os.path.abspath(os.path.join(folder_path, os.pardir))
    output_filename = os.path.join(parent_folder, "t10k-morpho.csv")

    df = df[["thickness", "intensity"]]
    df.index.name = 'index'  # Set the name for the index column
    df.to_csv(output_filename)

    return df

measure_folder("/home/ubuntu/Downloads/variational-causal-inference/data/morphomnist/perturbation_data_thickness/test-images")
