import torch
import transformers

# model link https://disk.yandex.ru/d/8kpU-sCLS2Xq-A
en_model = torch.jit.load("English_model.pt")
en_tokenizer = transformers.AutoTokenizer.from_pretrained("roberta-base")
out_en_tok = en_tokenizer("test data", return_tensors="pt")

# raw embedding, no two emb trick applied
out_en_model = en_model(out_en_tok["input_ids"], out_en_tok["attention_mask"])

# model link https://disk.yandex.ru/d/YGlZQjLf0gQCXg
multi_model = torch.jit.load("Multilingual_model.pt")
multi_tokenizer = transformers.AutoTokenizer.from_pretrained("bert-base-multilingual-cased")
out_multi_tok = multi_tokenizer("test data", return_tensors="pt")

# raw embedding, no two emb trick applied
out_multi_model = multi_model(out_multi_tok["input_ids"], out_multi_tok["attention_mask"])
