import logging
from lib.utils import UnifyConfig
import json

class BaseDataFmt(object):
    def __init__(self, cfg):
        self.cfg: UnifyConfig = cfg
        self.data_cfg: UnifyConfig = cfg.data_cfg
        self.eval_cfg: UnifyConfig = cfg.eval_cfg
        self.train_cfg: UnifyConfig = cfg.train_cfg
        self.environ_cfg: UnifyConfig = cfg.environ_cfg

        self.logger: logging.Logger = cfg.logger
        self.data_folder_path = cfg.data_folder_path

    @staticmethod
    def read_json(fph, encoding='utf-8'):
        with open(fph, 'r', encoding=encoding) as f:
            return json.load(f)
