import logging
from lib.utils import UnifyConfig
import importlib


class EntryPoint(object):
    def __init__(self, cfg: UnifyConfig):
        self.cfg: UnifyConfig = cfg
        self.data_cfg: UnifyConfig = cfg.data_cfg
        self.eval_cfg: UnifyConfig = cfg.eval_cfg
        self.train_cfg: UnifyConfig = cfg.train_cfg
        self.environ_cfg: UnifyConfig = cfg.environ_cfg
        self.model_cfg: UnifyConfig = cfg.model_cfg
        self.logger: logging.Logger = cfg.logger

        self.datafmt_cls = importlib.import_module('datafmt').__getattribute__(self.data_cfg['datafmt_cls'])
        self.model_cls = importlib.import_module('models').__getattribute__(self.model_cfg['model_cls'])

    def start(self):
        raise NotImplementedError
