from .configUtil import UnifyConfig
from .commonUtil import PathUtil, DecoratorTimer, IOUtil
from .loggerUtil import Logger
import os


def init_all(cfg: UnifyConfig, dataset, task):
    cfg.data_folder_path = f"{cfg.DATA_FOLDER_PATH}/{dataset}"
    PathUtil.check_path_exist(cfg.data_folder_path)

    cfg.TEMP_FOLDER_PATH = os.path.realpath(cfg.TEMP_FOLDER_PATH)
    cfg.SAVE_FOLDER_PATH = os.path.realpath(cfg.SAVE_FOLDER_PATH)

    cfg.temp_folder_path = f"{cfg.TEMP_FOLDER_PATH}/{dataset}/{task}/{cfg.model_cfg.model_cls}/{cfg.ID}"
    cfg.save_folder_path = f"{cfg.SAVE_FOLDER_PATH}/{dataset}/{task}/{cfg.model_cfg.model_cls}"
    PathUtil.auto_create_folder_path(
        cfg.temp_folder_path, cfg.save_folder_path
    )

    log_filepath = f"{cfg.temp_folder_path}/{cfg.ID}.log"
    if cfg.environ_cfg['log_without_date']:
        cfg.logger = Logger(filepath=log_filepath, fmt='[%(levelname)s]: %(message)s', date_fmt=None).get_std_logger()
    else:
        cfg.logger = Logger(filepath=log_filepath).get_std_logger()
    DecoratorTimer.logger = cfg.logger

    if cfg.environ_cfg['disable_tqdm'] is True:
        from tqdm import tqdm
        from functools import partialmethod
        tqdm.__init__ = partialmethod(tqdm.__init__, disable=True)
