# Constrained Multi-Objective Gradient Aggregator (CoMOGA)

## Requirements

- Python 3.8 or greater
- torch==1.12.1
- gymnasium
- safety_gymnasium
- scikit-learn
- pandas
- qpsolvers=1.9.0
- ruamel.yaml
- morl_baselines

## How to train

### Safety Gymnasium

- single task: `python main_safetygym.py --task_cfg_path tasks/{task_name}.yaml --algo_cfg_path algos/constrained/{algo_name}/safetygym.yaml --seed {seed_idx} --gpu_idx {gpu_idx} --wandb`
- multi task: `python main_safetygym.py --task_cfg_path tasks/{task_name}.yaml --algo_cfg_path algos/constrained/{algo_name}/ma_safetygym.yaml --seed {seed_idx} --gpu_idx {gpu_idx} --wandb`

or `bash scripts/train.sh`

### Legged Robot Locomotion

`python main_legged.py --task_cfg_path tasks/{task_name}.yaml --algo_cfg_path algos/constrained/{algo_name}/legged.yaml --seed {seed_idx} --gpu_idx {gpu_idx} --wandb`

### MO Gymnasium

`python main_mogym.py --task_cfg_path tasks/{task_name}.yaml --algo_cfg_path algos/unconstrained/{algo_name}/mogym.yaml --seed {seed_idx} --gpu_idx {gpu_idx} --wandb`

## How to test

### Safety Gymnasium

- single task: `python main_safetygym.py --task_cfg_path tasks/{task_name}.yaml --algo_cfg_path algos/constrained/{algo_name}/safetygym.yaml --seed {seed_idx} --gpu_idx {gpu_idx} --model_num {model_num} --test`
- multi task: `python main_safetygym.py --task_cfg_path tasks/{task_name}.yaml --algo_cfg_path algos/constrained/{algo_name}/ma_safetygym.yaml --seed {seed_idx} --gpu_idx {gpu_idx} --model_num {model_num} --test`

or `bash scripts/test.sh`

### Legged Robot Locomotion

`python main_legged.py --task_cfg_path tasks/{task_name}.yaml --algo_cfg_path algos/constrained/{algo_name}/legged.yaml --seed {seed_idx} --gpu_idx {gpu_idx} --model_num {model_num} --test`

### MO Gymnasium

`python main_mogym.py --task_cfg_path tasks/{task_name}.yaml --algo_cfg_path algos/unconstrained/{algo_name}/mogym.yaml --seed {seed_idx} --gpu_idx {gpu_idx} --model_num {model_num} --test`
