from algos.constrained.comoga.gaussian import Agent as CoMOGAConstGaussian
from algos.constrained.comoga.squash import Agent as CoMOGAConstSquash
from algos.constrained.pd_morl import Agent as PDMORLConst
from algos.constrained.cagrad import Agent as CAGradConst
from algos.constrained.capql import Agent as CAPQLConst
from algos.constrained.lp3 import Agent as LP3Const

from algos.unconstrained.pd_morl import Agent as PDMORL
from algos.unconstrained.comoga import Agent as CoMOGA
from algos.unconstrained.capql import Agent as CAPQL
from algos.unconstrained.lp3 import Agent as LP3

algo_dict = {
    'comoga_const_gaussian': CoMOGAConstGaussian,
    'comoga_const_squash': CoMOGAConstSquash,
    'pd_morl_const': PDMORLConst,
    'cagrad_const': CAGradConst,
    'capql_const': CAPQLConst,
    'lp3_const': LP3Const,
    'pd_morl': PDMORL,
    'comoga': CoMOGA,
    'capql': CAPQL,
    'lp3': LP3,
}