# Evaluation history

## Model : e5-small 

```bash
python scripts/baselines/captioning_evaluator.py coldoc/baseline_cap_syntheticDocQA_energy_test --model-name intfloat/multilingual-e5-small
python scripts/baselines/captioning_evaluator.py coldoc/baseline_cap_syntheticDocQA_artificial_intelligence_test --model-name intfloat/multilingual-e5-small
python scripts/baselines/captioning_evaluator.py coldoc/baseline_cap_syntheticDocQA_government_reports_test --model-name intfloat/multilingual-e5-small
python scripts/baselines/captioning_evaluator.py coldoc/baseline_cap_syntheticDocQA_healthcare_industry_test --model-name intfloat/multilingual-e5-small
python scripts/baselines/captioning_evaluator.py coldoc/baseline_cap_tabfquad_test_subsampled --model-name intfloat/multilingual-e5-small
python scripts/baselines/captioning_evaluator.py coldoc/baseline_cap_shiftproject_test --model-name intfloat/multilingual-e5-small


```

## Model : e5-large

```bash
python scripts/baselines/captioning_evaluator.py --dataset-name coldoc/baseline_cap_syntheticDocQA_energy_test --model-name intfloat/multilingual-e5-large
python scripts/baselines/captioning_evaluator.py--dataset-name coldoc/baseline_cap_syntheticDocQA_artificial_intelligence_test --model-name intfloat/multilingual-e5-large
python scripts/baselines/captioning_evaluator.py--dataset-name coldoc/baseline_cap_syntheticDocQA_government_reports_test --model-name intfloat/multilingual-e5-large
python scripts/baselines/captioning_evaluator.py --dataset-name coldoc/baseline_cap_syntheticDocQA_healthcare_industry_test --model-name intfloat/multilingual-e5-large
python scripts/baselines/captioning_evaluator.py --dataset-name coldoc/baseline_cap_tabfquad_test_subsampled --model-name intfloat/multilingual-e5-large
python scripts/baselines/captioning_evaluator.py --dataset-name coldoc/baseline_cap_shiftproject_test --model-name intfloat/multilingual-e5-large
python scripts/baselines/captioning_evaluator.py  --model-name intfloat/multilingual-e5-large

```

## Model : bge-m3

```bash
python scripts/baselines/captioning_evaluator.py --dataset-name coldoc/baseline_cap_syntheticDocQA_energy_test --model-name BAAI/bge-m3
python scripts/baselines/captioning_evaluator.py --dataset-name coldoc/baseline_cap_syntheticDocQA_artificial_intelligence_test --model-name BAAI/bge-m3
python scripts/baselines/captioning_evaluator.py --dataset-name coldoc/baseline_cap_syntheticDocQA_government_reports_test --model-name BAAI/bge-m3
python scripts/baselines/captioning_evaluator.py --dataset-name coldoc/baseline_cap_syntheticDocQA_healthcare_industry_test --model-name BAAI/bge-m3
python scripts/baselines/captioning_evaluator.py --dataset-name coldoc/baseline_cap_tabfquad_test_subsampled --model-name BAAI/bge-m3
python scripts/baselines/captioning_evaluator.py --dataset-name coldoc/baseline_cap_shiftproject_test --model-name BAAI/bge-m3
python scripts/baselines/captioning_evaluator.py --model-name BAAI/bge-m3
```



## Baselines

### Text chunk only BM25

```bash
python scripts/baselines/bm25.py --model-name bm25 --collection-name coldoc/ocrvisbaselines-666acce88c294ef415548a56 --text-only
```

### Text chunk only BGE-M3

```bash
python scripts/baselines/captioning_evaluator.py --model-name BAAI/bge-m3 --collection-name coldoc/ocrvisbaselines-666acce88c294ef415548a56 --text-only
```

### OCR Chunk BM25

```bash
python scripts/baselines/bm25.py --model-name bm25 --collection-name coldoc/ocrvisbaselines-666acce88c294ef415548a56

```

### OCR Chunk BGE-M3
```bash
python scripts/baselines/captioning_evaluator.py --model-name BAAI/bge-m3 --collection-name coldoc/ocrvisbaselines-666acce8
```

## Measure stored embedding size

```bash
python scripts/baselines/bm25.py  --model-name bm25 --dataset-name coldoc/baseline_cap_docvqa_test_subsampled
python scripts/baselines/captioning_evaluator.py --model-name BAAI/bge-m3 --dataset-name coldoc/baseline_cap_docvqa_test_subsampled
```
